### Test module ####
import random

from demoscript import *

class CurveScene(Scene):
	
	def __init__(self,sceneName):
		Scene.__init__(self)
		self.sceneProxy=SceneProxy(sceneName)
		self.setScene(self.sceneProxy)
		self.last_i=8
		self.first=1


	def callback(self):
		if getEvent(EC_NOTE_ON,"taptap"):

			meshes=self.getScene().getObjects()

			if self.first==1:
				for i in [8,10,11]:
					meshes[i].curveLength=FixedSlider(0,0)
				self.first=0

			kak=[1,2,3,4,5,6,7,9]
			for k in kak :
				meshes[k].red.setTargetValue(0)
				meshes[k].green.setTargetValue(0)
				meshes[k].blue.setTargetValue(0)


			ints=[8,10,11]
			ints.remove(self.last_i)
			i=random.choice(ints)

			meshes[i].curveLength.setTargetValue(1)
			meshes[i].curveTaper.setTargetValue(.2)
			meshes[i].curveWidth.setTargetValue(1)
			self.last_i=i
		
		
		if getEvent(EC_NOTE_ON,"reset1"):			
			self.nextCamera()

#		if getEvent(EC_NOTE_ON,"snare2"):
#			self.reset()


class UtilXMV(XMVPlayer):
	def callback(self):
		if getEvent(EC_NOTE_ON,"snare"):
			self.restart()

class RandomImage(Image):
	def __init__(self,img,xpos=0,ypos=0,xamp=1,yamp=1):
		Image.__init__(self,img,0,0)
		self.xpos=xpos
		self.ypos=ypos
		self.xamp=xamp
		self.yamp=yamp
	
	def setAmpY(self,amp):
		self.yamp=amp

	def setAmpX(self,amp):
		self.xamp=amp

	def callback(self):
		pass

	def revive(self):
		self.setPos(self.xpos+frand(-self.xamp,self.xamp),self.ypos+frand(-self.yamp,self.yamp))
		self.opacity.setTargetValue(2)
		self.scaleY.setTargetValue(0)



class ScrollImage(Image):
	def __init__(self,img,xpos=-2,ypos=0,xamp=1,yamp=1):
		Image.__init__(self,img,0,0)
		self.xpos=xpos
		self.ypos=ypos
		self.xamp=xamp
		self.yamp=yamp
		self.opacity=FixedSlider(1,1)
		self.posX=FixedSlider(3,3)
		self.posX.setMode(1)
		self.posX.setDamping(0.0085)
		self.posX.setFixPointDamping(0.99)
		
	def setAmpY(self,amp):
		self.yamp=amp

	def setAmpX(self,amp):
		self.xamp=amp

	def callback(self):
		pass

	def revive(self):
#		self.setPos(self.xpos+frand(-self.xamp,self.xamp),self.ypos+frand(-self.yamp,self.yamp))
		self.posX.setTargetValue(-3)

		
		self.opacity.setTargetValue(2)
#		self.scaleY.setTargetValue(0)



class MeneerImage(Image):
	def __init__(self,img,xpos=0,ypos=0,xamp=1,yamp=1):
		Image.__init__(self,img,0,0)
		self.xpos=xpos
		self.ypos=ypos
		self.xamp=xamp
		self.yamp=yamp
	
	def setAmpY(self,amp):
		self.yamp=amp

	def setAmpX(self,amp):
		self.xamp=amp


	def callback(self):
		self.setPos(frand(-0.5,0.5),0)

	def revive(self):
		self.setPos(self.xpos+frand(-self.xamp,self.xamp),self.ypos+frand(-self.yamp,self.yamp))
		self.opacity.setTargetValue(1)


class SimpleRipple(Ripple):
	def __init__(self):
		Ripple.__init__(self)
#		self.amplitude=FixedSlider(0,0)
		self.callbacks=[]

	def callback(self):
		for f in self.callbacks:
			f(self)





class SimpleImageSeq(ImageSeq):
	def __init__ (self,images=[],nextImage=[],take=0):
		ImageSeq.__init__(self)
		self.nextImageEvents=nextImage
		self.images=images
		for i in self.images:self.addImage(i)
		self.takeAmount=take

	
	def callback (self):
		for event in self.nextImageEvents:
			if getEvent(EC_NOTE_ON,event):
				if self.takeAmount > 0:
					self.take(self.takeAmount)
				else:
					self.next()


class AutoImageSeq(ImageSeq):
	def __init__ (self,images=[],time=10,take=0):
		ImageSeq.__init__(self)
#		self.nextImageEvents=nextImage
		self.images=images
		for i in self.images:self.addImage(i)
		self.takeAmount=take
		self.time=time
		self.curtime=0

	
	def callback (self):
#		for event in self.nextImageEvents:
		self.curtime+=1
		if self.curtime==self.time:
			if self.takeAmount > 0:
				self.take(self.takeAmount)
			else:
				self.next()
			self.curtime=0

				
			
class SimpleXMV(XMVPlayer):
	def __init__(self,name,events=[]):
		XMVPlayer.__init__(self,name)
		self.events=events
		
	def callback(self):
		for event in events:
			if getEvent(EC_NOTE_ON,event): self.restart()


class FixedGamma(RGBMap):
	def __init__(self,events=[],colors=[5,5,5]):
		RGBMap.__init__(self)
		self.gamma=MGGamma();
		self.gamma.connectOutput(self,"map")
		self.gamma.red=FixedSlider(colors[0],colors[0])
		self.gamma.green=FixedSlider(colors[1],colors[1])
		self.gamma.blue=FixedSlider(colors[2],colors[2])



	def callback(self):
		pass
		

#		self.events=events
#		self.gamma=MGGamma();
#		self.gamma.connectOutput(self,"map")

class SimpleGamma(RGBMap):
	def __init__(self,events=[],colors=[5,5,5]):
		RGBMap.__init__(self)
		self.events=events
		self.gamma=MGGamma();
		self.gamma.connectOutput(self,"map")
		self.colors=colors
		self.gamma.red.setFixPointDamping(0.97)
		self.gamma.green.setFixPointDamping(0.97)
		self.gamma.blue.setFixPointDamping(0.97)

	
	def callback(self):
		for event in self.events:
			if getEvent(EC_NOTE_ON,event):
				sg=self.gamma
				for i in zip([sg.red,sg.green,sg.blue],self.colors):i[0].setTargetValue(i[1])

class SimpleOverflow(RGBMap):
	def __init__(self,events=[],colors=[0.9,0.9,0.4]):
		RGBMap.__init__(self)
		self.events=events
		self.gamma=MGOverflow();
		self.gamma.connectOutput(self,"map")
		self.colors=colors
		self.gamma.red.setFixPointDamping(0.97)
		self.gamma.green.setFixPointDamping(0.97)
		self.gamma.blue.setFixPointDamping(0.97)

	
	def callback(self):
		for event in self.events:
			if getEvent(EC_NOTE_ON,event):
				sg=self.gamma
				for i in zip([sg.red,sg.green,sg.blue],self.colors):i[0].setTargetValue(i[1])

	

class RandomOverflow(RGBMap):
	def __init__(self,events=[],colors=[0.9,0.9,0.4]):
		RGBMap.__init__(self)
		self.events=events
		self.gamma=MGOverflow();
		self.gamma.connectOutput(self,"map")
		self.colors=colors
		self.gamma.red.setFixPointDamping(1)
		self.gamma.green.setFixPointDamping(1)
		self.gamma.blue.setFixPointDamping(1)

	
	def callback(self):
		for event in self.events:
			if getEvent(EC_NOTE_ON,event):
				sg=self.gamma
				for i in zip([sg.red,sg.green,sg.blue],self.colors):i[0].setTargetValue(frand(-20,20))



class SimpleBlur(Blur):
	def __init__(self,events=[],restv=0.0,highv=1.0):
		Blur.__init__(self)
		self.m_events=events
		self.mix=FixedSlider(restv,restv)
		self.highv=highv
	
	def callback(self):
		for event in self.m_events:
			if getEvent(EC_NOTE_ON,event):
				self.mix.setTargetValue(self.highv)
				self.mix.setFixPointDamping(0.9995)
				self.mix.setDamping(0.97)

class SimpleDistort(Distort):
	def __init__(self,event=[],distVal=0):
		Distort.__init__(self)
		self.m_event=event
		self.amount=FixedSlider(distVal,distVal)
		

	def callback(self):
		for event in self.m_event:
			if getEvent(EC_NOTE_ON,event[1]):
				self.amount.setTargetValue(event[0])
				self.amount.setFixPointDamping(0.99)
				self.amount.setDamping(0.97)
				


	


class SimpleNoise(Noise):
	""" SimpleNoise renders noise 
	"""
	

	def __init__(self,event,intensity=0.6,eventIntensity=1.3):
		Noise.__init__(self)
		self.m_event=event
		self.intensity=FixedSlider(intensity,intensity)
		self.eventIntensity=eventIntensity
		self.intensity.setFixPointDamping(0.96)
	def callback(self):
		for event in self.m_event:
			if getEvent(EC_NOTE_ON,event):
				self.spread.setTargetValue(0)
				self.intensity.setTargetValue(self.eventIntensity)
			
#HELEMAAL NIET ZO SIMPEL!


class SimpleScene(Scene):
	""" 
	Simple scene renders the given scene and responds to events defined in nextCamera and reset.
	"""

	def __init__(self,sceneName,nextCamera=[],reset=[],cameraOrder=[],offsets=[],curveEvents=[],noiseEvents=[],speeds=[],defaultspeed=8000,transforms=[],colors=[],curveWidth=5):
		Scene.__init__(self)
		self.sceneProxy=SceneProxy(sceneName)
		self.setScene(self.sceneProxy)
		if cameraOrder==[]:cameraOrder=range(self.getNumCameras())
		self.cameraOrder=cameraOrder
		self.nextCameraEvents=nextCamera
		self.resetEvents=reset
		self.speed=FixedSlider(defaultspeed,defaultspeed)
		self.curveWidth=curveWidth


		self.curCam=0
#		self.setCamera(cameraOrder[0])
		self.offsetEvents=offsets
		self.speedEvents=speeds

		self.curveEvents=curveEvents
		self.noiseEvents=noiseEvents

		self.transformEvents=transforms
		self.colorEvents=colors
#		self.setCamera(1)

		meshes=self.getScene().getObjects()
		for transform in self.transformEvents:
			meshes[transform[0]].addTransform(transform[1])

	def callback(self):
		for nc in self.nextCameraEvents:
			if getEvent(EC_NOTE_ON,nc):
				pass
				if self.cameraOrder==[]:
				  self.nextCamera()
				else:
				  self.curCam=self.curCam+1
				  if self.curCam==len(self.cameraOrder):
				    self.curCam=0
	
		if self.cameraOrder!=[]:
		  self.setCamera(self.cameraOrder[self.curCam])


		for rc in self.resetEvents:
			if getEvent(EC_NOTE_ON,rc):
				self.reset()

		for offset in self.offsetEvents:
			if getEvent(EC_NOTE_ON,offset[1]):
				self.offset.setTargetValue(offset[0])
			
		for speed in self.speedEvents:
			if getEvent(EC_NOTE_ON,speed[1]):
				self.speed.setTargetValue(speed[0])

		
		for transform in self.transformEvents:
			if getEvent(EC_NOTE_ON,transform[2]):
				# HACK THIS WAS NEEDED FOR POLAR BEAR ALERT
				if frand(0,4) < 1 :
					scale=frand(2,3)
					transform[1].x.setTargetValue(scale)
					transform[1].y.setTargetValue(scale)
					transform[1].z.setTargetValue(scale)

			
#process curves
		if len(self.curveEvents)>0:	#hack
			meshes=self.getScene().getObjects()
			for event in self.curveEvents:
				if getEvent(EC_NOTE_ON,event[1]):
					if event[0]<len(meshes):
						meshes[event[0]].curveWidth.setMode(1)
						meshes[event[0]].curveWidth.setTargetValue(frand(2,4))
						meshes[event[0]].curveLength.setMode(2)
						meshes[event[0]].curveLength.setFixPointDamping(0.99)
						meshes[event[0]].curveLength.setDamping(0.4)
						meshes[event[0]].curveLength.setTargetValue(frand(0,1))
						meshes[event[0]].curveBumpFreq.setMode(1)
						meshes[event[0]].curveBumpAmplitude.setMode(1)
						meshes[event[0]].curveBumpFreq.setTargetValue(5)
						meshes[event[0]].curveBumpAmplitude.setTargetValue(0.6)
					
			
#process perlin noise
		if len(self.noiseEvents)>0:	#hack
			meshes=self.getScene().getObjects()
			for event in self.noiseEvents:
				if getEvent(EC_NOTE_ON,event[1]):
					if event[0]<len(meshes):

						meshes[event[0]].noiseAmplitude.setFixPointDamping(0.9995)
						meshes[event[0]].noiseAmplitude.setTargetValue(25)
						meshes[event[0]].noiseFreq.setTargetValue(0.02)
						meshes[event[0]].noiseFreq.setFixPoint(0.025)
						meshes[event[0]].noiseOffset.setMode(1)
						meshes[event[0]].noiseOffset.setDamping(0.01)
						meshes[event[0]].noiseOffset.setTargetValue(1000)
		


#process color modulation
		if len(self.colorEvents)>0:	#hack

			meshes=self.getScene().getObjects()
			for event in self.colorEvents:
				if getEvent(EC_NOTE_ON,event[1]):
					if event[0]<len(meshes):
						meshes[event[0]].red.setTargetValue(0)
						meshes[event[0]].green.setTargetValue(0)
						meshes[event[0]].blue.setTargetValue(0)

# hmhmhmhm daarnet werkte het nog
# als dit werkt eet ik mijn schoen op
		event=Event()
		if getEvent(EC_NOTE_CONTROL,0,6,event):
			#misschien moet dit meer zijn! 
			for mesh in meshes:
				mesh.red.setTargetValue(1.0-event.volume)
				mesh.green.setTargetValue(1.0-event.volume)
				mesh.blue.setTargetValue(1.0-event.volume)

				
				
		
		
